<?php

if (!defined('PHPLISTINIT')) {
    die('Direct access not allowed');
}

class domainthrottlemap extends phplistPlugin
{
    public $name        = 'Domain Throttle Map (Celiac Custom Tuned)';
    public $authors     = 'Scott Adams, ChatGPT';
    public $version     = '1.2.0';
    public $enabled     = 1;
    public $description = 'Refined per-domain throttling based on actual subscriber distribution.';
    public $coderoot    = '';
    public $topMenuLinks = array();

    public function __construct()
    {
        parent::__construct();
    }

    public function adminmenu()
    {
        return array();
    }

    public function dependencyCheck()
    {
        $errors = array();

        if (!class_exists('phplistPlugin')) {
            $errors[] = 'phplistPlugin base class missing.';
        }

        if (defined('PHPLIST_VERSION') &&
            version_compare(PHPLIST_VERSION, '3.3.0', '<')) {
            $errors[] = 'phpList 3.3.0+ is required.';
        }

        return $errors;
    }

    /*-----------------------------------------------------------
     * DOMAIN BUCKET ASSIGNMENT
     *----------------------------------------------------------*/
    public function throttleDomainMap($domain)
    {
        $domain = strtolower($domain);

        if (strpos($domain, '@') !== false) {
            $domain = substr(strrchr($domain, '@'), 1);
        }

        /* ---- Major Buckets (based on your real data) ---- */

        // 35k+ Gmail
        if (preg_match('/^(gmail\.com|googlemail\.com)$/', $domain)) {
            return 'Gmail';
        }

        // Yahoo family ~13k+ users
        if (preg_match('/^yahoo\.(com|ca|co\.[a-z]{2}|[a-z]{2})$/', $domain) ||
            $domain === 'ymail.com' ||
            $domain === 'rocketmail.com') {
            return 'Yahoo';
        }

        // Microsoft family (~17k): hotmail, outlook, msn, live
        if (preg_match('/^(hotmail\.(com|ca|co\.[a-z]{2}|[a-z]{2})|outlook\.com|msn\.com|live\.(com|ca)|hotmail\.co\.uk)$/', $domain)) {
            return 'Microsoft';
        }

        // AOL + Verizon (delivered by AOL)
        if ($domain === 'aol.com' || $domain === 'verizon.net') {
            return 'AOL';
        }

        // Comcast (very strict)
        if ($domain === 'comcast.net') {
            return 'Comcast';
        }

        // AT&T/SBC/Bellsouth family (legacy AT&T)
        if (in_array($domain, ['att.net','sbcglobal.net','bellsouth.net'])) {
            return 'ATT';
        }

        // Cox (also strict)
        if ($domain === 'cox.net') {
            return 'Cox';
        }

        // Apple (icloud/me/mac) ~1600+
        if (in_array($domain, ['icloud.com','me.com','mac.com'])) {
            return 'Apple';
        }

        // Cablevision / OptOnline
        if ($domain === 'optonline.net') {
            return 'OptOnline';
        }

        // Canadian ISPs
        if ($domain === 'shaw.ca' || $domain === 'rogers.com') {
            return 'Canada';
        }

        // Default: standalone domain bucket
        return $domain;
    }

    /*-----------------------------------------------------------
     * MULTIPLIERS — tuned for speed + safety
     *----------------------------------------------------------*/
    public function sendPerInterval($bucket, $baseline)
    {
        if (!is_numeric($baseline) || $baseline <= 0) {
            return $baseline;
        }

        switch ($bucket) {

            /* ---- Tuned for your list ---- */

            // Gmail huge but tolerant
            case 'Gmail':
                return $baseline * 0.85;

            // Yahoo very strict (NDR waves if too fast)
            case 'Yahoo':
                return $baseline * 0.6;

            // Hotmail/Outlook/MSN ~17k
            case 'Microsoft':
                return $baseline * 0.7;

            // AOL + Verizon
            case 'AOL':
                return $baseline * 0.7;

            // Comcast strictest large ISP
            case 'Comcast':
                return $baseline * 0.4;

            // AT&T / SBC / Bellsouth (large chunk)
            case 'ATT':
                return $baseline * 0.55;

            // Cox also strict
            case 'Cox':
                return $baseline * 0.4;

            // Apple users — very tolerant
            case 'Apple':
                return $baseline * 0.8;

            // OptOnline/Cablevision
            case 'OptOnline':
                return $baseline * 0.75;

            // Canadian ISPs (generally tolerant)
            case 'Canada':
                return $baseline * 0.85;

            /* Default — safe full baseline */
            default:
                return $baseline;
        }
    }
}
